/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

    @version $Id: EcatFoE_FH_Functionlist.h 56610 2015-10-02 09:46:22Z Sven $

**************************************************************************************/

#ifndef __ECAT_FOE_FH_FUNCTIONLIST_H
#define __ECAT_FOE_FH_FUNCTIONLIST_H

#ifndef TLR_TASK_ECAT_FOE_FH
#define TLR_TASK_ECAT_FOE_FH             ((TLR_TASKIDENTIFIER)0x00240002L)
#endif



/***************************************************************************************/
/* Ecat FoE function list, prototyes */

TLR_RESULT
TaskExit_EcatFoE_FH(
    void* pvRsc);

TLR_RESULT
TaskLeave_EcatFoE_FH(
    void* pvRsc,
    void* pvLve);

void
TaskEnter_EcatFoE_FH(
    void* pvInit);


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define ECAT_FOE_FH_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** type of <code>ECAT_FOE_STARTUPPARAMETER_Ttag</code> */
typedef struct ECAT_FOE_FH_STARTUPPARAMETER_Ttag  ECAT_FOE_FH_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct ECAT_FOE_FH_STARTUPPARAMETER_Ttag    /* Task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
  /** initialize FoE stack with internal volume handler */
  TLR_BOOLEAN32   fUseVolumeCallback;
  /** mount volume if not done */
  TLR_BOOLEAN32   fAutoMount;
  /** name for FoE stack internal volume handler */
  TLR_STR         szVolumeName[16];
  /** name of filesystem to expect */
  TLR_STR         szFileSystem[16];
  /** netx device type of nxf to expect during file download */
  TLR_UINT16      usNxfDeviceClass;
};

/** @} */

/***************************************************************************************/
#endif /* #ifndef __ECAT_FOE_FH_FUNCTIONLIST_H */
